<?php
/**
 * This file is used to generate the "Maintenance" page in the admin.
 *
 * @package live-news
 */

if ( ! current_user_can( get_option( $this->shared->get( 'slug' ) . '_maintenance_menu_capability' ) ) ) {
	wp_die( esc_html__( 'You do not have sufficient permissions to access this page.', 'daln' ) );
}

?>

<!-- process data -->

<?php

// Init Vars.
$dismissible_notice_a = array();

if ( isset( $_POST['form_submitted'] ) ) {

	// Nonce verification.
	check_admin_referer( 'daln_perform_maintenance_task', 'daln_perform_maintenance_task_nonce' );

	// Sanitization.
	$task = isset( $_POST['task'] ) ? intval( $_POST['task'], 10 ) : null;

	switch ( $task ) {

		// Reset Plugin.
		case 0:
			// Delete the records of all the database tables of the plugin.
			$this->shared->reset_plugin_database_tables();

			// Set the default values of the options.
			$this->shared->reset_plugin_options();

			// Add the dismissible notice message.
			$dismissible_notice_a[] = array(
				'message' => __( 'The plugin data have been successfully deleted.', 'daln' ),
				'class'   => 'updated',
			);

			break;

		// Delete Transients.
		case 1:
			// Delete all the transients associated with the tickers.
			global $wpdb;
			$table_name = $wpdb->prefix . $this->shared->get( 'slug' ) . '_tickers';
			$results    = $wpdb->get_results( "SELECT id FROM $table_name", ARRAY_A );
			foreach ( $results as $result ) {
				delete_transient( 'daln_ticker_' . $result['id'] );
			}

			// Add the dismissible notice message.
			$dismissible_notice_a[] = array(
				'message' => __( 'The transients have been successfully deleted.', 'daln' ),
				'class'   => 'updated',
			);

			break;

	}
}

?>

<!-- output -->

<div class="wrap">

	<div id="daext-header-wrapper" class="daext-clearfix">

		<h2><?php esc_html_e( 'Live News - Maintenance', 'daln' ); ?></h2>

	</div>

	<div id="daext-menu-wrapper">

		<?php $this->dismissible_notice( $dismissible_notice_a ); ?>

		<!-- table -->

		<div>

			<form id="form-maintenance" method="POST"
					action="admin.php?page=<?php echo esc_attr( $this->shared->get( 'slug' ) ); ?>-maintenance"
					autocomplete="off">

				<input type="hidden" value="1" name="form_submitted">
				<?php wp_nonce_field( 'daln_perform_maintenance_task', 'daln_perform_maintenance_task_nonce' ); ?>

				<div class="daext-form-container">

					<div class="daext-form-title"><?php esc_html_e( 'Maintenance', 'daln' ); ?></div>

					<table class="daext-form daext-form-table">

						<!-- Task -->
						<tr>
							<th scope="row"><?php esc_html_e( 'Task', 'daln' ); ?></th>
							<td>
								<select id="task" name="task" class="daext-display-none">
									<option value="0"><?php esc_html_e( 'Reset Plugin', 'daln' ); ?></option>
									<option value="1"><?php esc_html_e( 'Delete Transients', 'daln' ); ?></option>
								</select>
								<div class="help-icon"
									title='
									<?php
									esc_attr_e(
										'The task that should be performed.',
										'daln'
									);
									?>
										'></div>
							</td>
						</tr>

					</table>

					<!-- submit button -->
					<div class="daext-form-action">
						<input id="execute-task" class="button" type="submit"
								value="<?php esc_attr_e( 'Execute Task', 'daln' ); ?>">
					</div>

				</div>

			</form>

		</div>

	</div>

</div>

<!-- Dialog Confirm -->
<div id="dialog-confirm" title="<?php esc_attr_e( 'Execute the task?', 'daln' ); ?>" class="daext-display-none">
	<p>
		<?php
		esc_html_e(
			'Do you really want to proceed?',
			'daln'
		);
		?>
	</p>
</div>